/*
 * Decompiled with CFR 0.152.
 */
package es.fnmtrcm.ceres.st.aplicaciones;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.ECGenParameterSpec;
import org.apache.log4j.Logger;
import sun.security.pkcs10.PKCS10;
import sun.security.x509.X500Name;

public class GenerarCSR {
    private static Logger logger = Logger.getLogger(GenerarCSR.class);
    private PublicKey publicKey = null;
    private PrivateKey privateKey = null;
    private KeyPairGenerator keyGen = null;

    public GenerarCSR(String longClave) {
        try {
            logger.debug("Iniciamos la generaci\u00f3n del CSR.");
            this.keyGen = KeyPairGenerator.getInstance("EC");
            ECGenParameterSpec ecSpec = new ECGenParameterSpec(longClave);
            this.keyGen.initialize(ecSpec);
            logger.debug("Fin de la generaci\u00f3n de las claves.");
        }
        catch (Exception e) {
            logger.error("__________ BEGIN GenerarCSR ERROR__________");
            logger.error("MENSAJE: " + e.toString());
            logger.error("DESCRIPCI\u00d3N: " + e.getMessage(), e);
            logger.error("__________ END GenerarCSR ERROR__________");
        }
        KeyPair keypair = this.keyGen.generateKeyPair();
        this.publicKey = keypair.getPublic();
        this.privateKey = keypair.getPrivate();
    }

    public String getCSR(String cn) throws Exception {
        return this.generarPKCS10(cn, "Ceres", "FNMT-RCM", "Madrid", "Madrid", "ES");
    }

    private String generarPKCS10(String CN, String OU, String O, String L, String S, String C) {
        String sPKCS10 = null;
        try {
            logger.debug("Iniciamos la generaci\u00f3n del PKCS#10.");
            String sigAlg = "SHA384withECDSA";
            logger.debug("Algoritmo de firma :: " + sigAlg);
            PKCS10 pkcs10 = new PKCS10(this.publicKey);
            logger.debug("PKCS#10 :: " + pkcs10.toString());
            Signature signature = Signature.getInstance(sigAlg);
            signature.initSign(this.privateKey);
            X500Name x500Name = new X500Name(CN, OU, O, L, S, C);
            logger.debug("x500Name :: " + x500Name.toString());
            pkcs10.encodeAndSign(x500Name, signature);
            logger.debug("PKCS#10 codificado");
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(bs);
            pkcs10.print(ps);
            logger.debug("PKCS#10 copiado al ByteArrayOutputStream");
            byte[] c = bs.toByteArray();
            logger.debug("PKCS#10 copiado al ByteArrayOutputStream");
            sPKCS10 = new String(c);
            sPKCS10 = sPKCS10.replace("-----BEGIN NEW CERTIFICATE REQUEST-----", "");
            sPKCS10 = sPKCS10.replace("\n", "").replace("\r", "");
            sPKCS10 = sPKCS10.replace("-----END NEW CERTIFICATE REQUEST-----", "");
            logger.debug("Finalizada la generaci\u00f3n del PKCS#10.");
            if (ps != null) {
                ps.close();
            }
            if (bs != null) {
                bs.close();
            }
        }
        catch (Exception e) {
            logger.error("__________ BEGIN generarPKCS10 ERROR__________");
            logger.error("MENSAJE: " + e.toString());
            logger.error("DESCRIPCI\u00d3N: " + e.getMessage(), e);
            logger.error("__________ END generarPKCS10 ERROR__________");
        }
        return sPKCS10;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }
}

