/*
 * Decompiled with CFR 0.152.
 */
package es.fnmtrcm.ceres.st.aplicaciones;

import es.fnmtrcm.ceres.st.utiles.Utiles;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.spec.PKCS8EncodedKeySpec;
import sun.misc.BASE64Encoder;

public class GenerarCertificado {
    public static void genCertificado(String cPublica, String cPrivada, String password) throws Exception {
        KeyStore store = KeyStore.getInstance("PKCS12");
        store.load(null, null);
        byte[] bDatos = Utiles.leerFichero(cPublica);
        String sCertificado = null;
        if (Utiles.isBinary(bDatos)) {
            BASE64Encoder encoder = new BASE64Encoder();
            sCertificado = encoder.encode(Utiles.leerFichero(cPublica));
        } else {
            sCertificado = new String(bDatos);
        }
        sCertificado = Utiles.verifyBeginEndBoundaries(sCertificado);
        ByteArrayInputStream bais = new ByteArrayInputStream(sCertificado.getBytes());
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        Certificate[] chain = new Certificate[]{};
        chain = certificateFactory.generateCertificates(bais).toArray(chain);
        bais.close();
        byte[] encodedKey = Utiles.leerFichero(cPrivada);
        KeyFactory rSAKeyFactory = KeyFactory.getInstance("EC");
        PrivateKey privateKey = rSAKeyFactory.generatePrivate(new PKCS8EncodedKeySpec(encodedKey));
        store.setKeyEntry("Certificado Componente", privateKey, password.toCharArray(), chain);
        String nP12 = cPrivada.replace("key", "p12");
        FileOutputStream fOut = new FileOutputStream(nP12);
        store.store(fOut, password.toCharArray());
        fOut.close();
    }
}

