/*
 * Decompiled with CFR 0.152.
 */
package es.fnmtrcm.ceres.st.gui;

import es.fnmtrcm.ceres.st.aplicaciones.GenerarCSR;
import es.fnmtrcm.ceres.st.aplicaciones.GenerarCertificado;
import es.fnmtrcm.ceres.st.gui.UtilesGUI;
import es.fnmtrcm.ceres.st.utiles.Utiles;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;

public class GUI
extends JFrame {
    private static Logger logger = Logger.getLogger(GUI.class);
    private static final long serialVersionUID = 1L;
    private JPanel contentPane;
    private JTextField textDirectorio;
    private JTextField textNombreDesc;
    private JTextField textClavePriv;
    private JTextField textClavePub;
    private JPasswordField passwordFieldRe;
    private JPasswordField passwordField;

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    GUI frame = new GUI();
                    frame.setVisible(true);
                }
                catch (Exception e) {
                    logger.error("__________ BEGIN main ERROR__________");
                    logger.error("MENSAJE: " + e.toString());
                    logger.error("DESCRIPCI\u00d3N: " + e.getMessage(), e);
                    logger.error("__________ END main ERROR__________");
                }
            }
        });
    }

    public GUI() {
        this.setResizable(false);
        this.setTitle("Generador de Claves para Certificados de Componente EC (CERES FNMT-RCM) v1.0");
        this.setDefaultCloseOperation(3);
        this.setBounds(100, 100, 640, 720);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        JLabel lblSeleccioneElDirectorio = new JLabel("1. Seleccione el directorio donde desea almacenar las claves del certificado.");
        JButton btnExaminar = new JButton("Examinar...");
        btnExaminar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUI.this.textDirectorio.setText(UtilesGUI.seleccionarDirectorio());
            }
        });
        this.textDirectorio = new JTextField();
        this.textDirectorio.setColumns(10);
        JLabel lblIndiqueUn = new JLabel("2. Indique un nombre descriptivo para la clave.");
        this.textNombreDesc = new JTextField();
        this.textNombreDesc.setColumns(10);
        JLabel lblGenerarClaves = new JLabel("3. Generar claves.");
        final JComboBox<String> comboBox = new JComboBox<String>();
        comboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"secp384r1"}));
        JButton btnGenerarClaves = new JButton("Generar Claves");
        btnGenerarClaves.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GenerarCSR gcsr = new GenerarCSR((String)comboBox.getSelectedItem());
                    if (GUI.this.textDirectorio.getText().equals("")) {
                        UtilesGUI.mostrarMensaje("Debe seleccionar un directorio en el paso 1");
                    } else if (GUI.this.textNombreDesc.getText().equals("")) {
                        UtilesGUI.mostrarMensaje("Debe indicar un nombre descriptivo para el certificado en el paso 2");
                    } else {
                        Utiles.guardarFichero(String.valueOf(GUI.this.textDirectorio.getText()) + System.getProperty("file.separator") + GUI.this.textNombreDesc.getText() + ".pkcs10", gcsr.getCSR("cn=Prerregistro componentes, o=CERES, c=ES").getBytes());
                        Utiles.guardarFichero(String.valueOf(GUI.this.textDirectorio.getText()) + System.getProperty("file.separator") + GUI.this.textNombreDesc.getText() + ".key", Utiles.convetirPKCS8(gcsr.getPrivateKey()));
                        UtilesGUI.mostrarMensaje("Las claves se han generado con \u00e9xito en " + GUI.this.textDirectorio.getText());
                    }
                }
                catch (Exception e2) {
                    logger.error("__________ BEGIN GUI ERROR__________");
                    logger.error("MENSAJE: " + e2.toString());
                    logger.error("DESCRIPCI\u00d3N: " + e2.getMessage(), e2);
                    logger.error("__________ END GUI ERROR__________");
                    UtilesGUI.mostrarMensaje("Se ha producido un error, consulte el fichero de log_gccc.log");
                }
            }
        });
        JLabel lblPaGeneracin = new JLabel("Etapa 1. Generaci\u00f3n de las Claves");
        JLabel lblEtapaGeneracin = new JLabel("Etapa 2. Generaci\u00f3n del Certificado");
        JLabel lblSeleccioneLa = new JLabel("4. Seleccione la clave privada (.key) del certificado solicitado. (Estar\u00e1 en el directorio que indic\u00f3 en el paso 1)");
        JButton btnExaminar_1 = new JButton("Examinar...");
        btnExaminar_1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUI.this.textClavePriv.setText(UtilesGUI.seleccionarFichero());
            }
        });
        this.textClavePriv = new JTextField();
        this.textClavePriv.setColumns(10);
        JLabel lblSeleccioneEl = new JLabel("5. Seleccione el certificado (clave p\u00fablica) que ha descargado de nuestra p\u00e1gina (.crt/.cer)");
        JButton btnExaminar_2 = new JButton("Examinar...");
        btnExaminar_2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUI.this.textClavePub.setText(UtilesGUI.seleccionarFichero());
            }
        });
        this.textClavePub = new JTextField();
        this.textClavePub.setColumns(10);
        JLabel lblIntroduzcaLa = new JLabel("6. Introduzca la password para proteger el certificado (opcional)");
        JLabel lblGenereEl = new JLabel("7.Confirmar password");
        JSeparator separator = new JSeparator();
        JLabel lblGenerarCertificado = new JLabel("8. Generar Certificado");
        JButton btnGenerarCertificado = new JButton("Generar Certificado");
        btnGenerarCertificado.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    if (!GUI.this.textClavePriv.getText().equals("")) {
                        if (!GUI.this.textClavePub.getText().equals("")) {
                            if (new String(GUI.this.passwordField.getPassword()).equals(new String(GUI.this.passwordFieldRe.getPassword()))) {
                                GenerarCertificado.genCertificado(GUI.this.textClavePub.getText(), GUI.this.textClavePriv.getText(), new String(GUI.this.passwordField.getPassword()));
                                UtilesGUI.mostrarMensaje("El certificado se ha generado con \u00e9xito en " + GUI.this.textClavePriv.getText().replace("key", "p12"));
                            } else {
                                UtilesGUI.mostrarMensaje("La contrase\u00f1a no coincide, por favor, introd\u00fazcala de nuevo en ambos campos habilitados a este efecto.");
                            }
                        } else {
                            UtilesGUI.mostrarMensaje("Debe seleccionar el fichero que contiene la clave p\u00fablica en el paso 5.");
                        }
                    } else {
                        UtilesGUI.mostrarMensaje("Debe seleccionar el fichero que contiene la clave privada en el paso 4.");
                    }
                }
                catch (Exception e1) {
                    logger.error("__________ BEGIN GUI ERROR__________");
                    logger.error("MENSAJE: " + e1.toString());
                    logger.error("DESCRIPCI\u00d3N: " + e1.getMessage(), e1);
                    logger.error("__________ END GUI ERROR__________");
                    UtilesGUI.mostrarMensaje("Se ha producido un error, consulte el fichero de log_gccc.log");
                }
            }
        });
        this.passwordFieldRe = new JPasswordField();
        this.passwordField = new JPasswordField();
        JSeparator separator_1 = new JSeparator();
        JTextPane txtpnUnaVezObtenidas = new JTextPane();
        txtpnUnaVezObtenidas.setForeground(Color.WHITE);
        txtpnUnaVezObtenidas.setBackground(Color.WHITE);
        txtpnUnaVezObtenidas.setDisabledTextColor(Color.RED);
        txtpnUnaVezObtenidas.setEnabled(false);
        txtpnUnaVezObtenidas.setEditable(false);
        txtpnUnaVezObtenidas.setText("NOTA: Una vez obtenidas las claves, dir\u00edjase a la aplicaci\u00f3n de pre-registro de componentes adecuada para hacer la solicitud del certificado. Finalizado el proceso de emisi\u00f3n del certificado, desc\u00e1rguelo de nuestra web y siga los pasos indicados en la segunda etapa.");
        GroupLayout gl_contentPane = new GroupLayout(this.contentPane);
        gl_contentPane.setHorizontalGroup(gl_contentPane.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(gl_contentPane.createSequentialGroup().addGroup(gl_contentPane.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, gl_contentPane.createSequentialGroup().addComponent(btnExaminar).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textDirectorio, -1, 509, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, gl_contentPane.createSequentialGroup().addComponent(btnExaminar_1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textClavePriv, -1, 509, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, gl_contentPane.createSequentialGroup().addComponent(btnExaminar_2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textClavePub, -1, 509, Short.MAX_VALUE)).addComponent(this.textNombreDesc, GroupLayout.Alignment.TRAILING, -1, 604, Short.MAX_VALUE).addComponent(txtpnUnaVezObtenidas, GroupLayout.Alignment.TRAILING, 0, 0, Short.MAX_VALUE).addComponent(this.passwordField, GroupLayout.Alignment.TRAILING, -1, 604, Short.MAX_VALUE).addComponent(this.passwordFieldRe, GroupLayout.Alignment.TRAILING, -1, 604, Short.MAX_VALUE).addComponent(btnGenerarCertificado, GroupLayout.Alignment.TRAILING, -1, 604, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, gl_contentPane.createSequentialGroup().addContainerGap().addComponent(separator_1, -2, 600, -2)).addGroup(GroupLayout.Alignment.TRAILING, gl_contentPane.createSequentialGroup().addComponent(lblGenerarClaves).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 487, Short.MAX_VALUE).addComponent(comboBox, -2, -1, -2)).addComponent(btnGenerarClaves, GroupLayout.Alignment.TRAILING, -1, 604, Short.MAX_VALUE).addComponent(separator, GroupLayout.Alignment.TRAILING, -1, 604, Short.MAX_VALUE).addComponent(lblPaGeneracin).addComponent(lblSeleccioneElDirectorio).addComponent(lblIndiqueUn).addComponent(lblEtapaGeneracin).addComponent(lblSeleccioneLa).addComponent(lblSeleccioneEl).addComponent(lblIntroduzcaLa).addComponent(lblGenereEl).addComponent(lblGenerarCertificado)).addContainerGap()));
        gl_contentPane.setVerticalGroup(gl_contentPane.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_contentPane.createSequentialGroup().addGap(7).addComponent(lblPaGeneracin).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(lblSeleccioneElDirectorio).addGap(11).addGroup(gl_contentPane.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(btnExaminar).addComponent(this.textDirectorio, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(lblIndiqueUn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textNombreDesc, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(gl_contentPane.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(comboBox, -2, -1, -2).addComponent(lblGenerarClaves)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(btnGenerarClaves).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(separator, -2, -1, -2).addGap(11).addComponent(txtpnUnaVezObtenidas, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(separator_1, -2, 20, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(lblEtapaGeneracin).addGap(16).addComponent(lblSeleccioneLa).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(gl_contentPane.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(btnExaminar_1).addComponent(this.textClavePriv, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(lblSeleccioneEl).addGap(13).addGroup(gl_contentPane.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(btnExaminar_2).addComponent(this.textClavePub, -2, -1, -2)).addGap(11).addComponent(lblIntroduzcaLa).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.passwordField, -2, -1, -2).addGap(11).addComponent(lblGenereEl).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.passwordFieldRe, -2, -1, -2).addGap(11).addComponent(lblGenerarCertificado).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(btnGenerarCertificado).addContainerGap(78, Short.MAX_VALUE)));
        this.contentPane.setLayout(gl_contentPane);
    }
}

