/*
 * Decompiled with CFR 0.152.
 */
package es.fnmtrcm.ceres.st.utiles;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class Utiles {
    private static final String BEGIN_CERTIFICATE_BOUNDARY_TAG = "-----BEGIN CERTIFICATE-----";
    private static final String END_CERTIFICATE_BOUNDARY_TAG = "-----END CERTIFICATE-----";
    private static final String LINE_SEPARATOR = "\r\n";

    public static byte[] leerFichero(String fichero) throws Exception {
        FileInputStream fis = new FileInputStream(fichero);
        BufferedInputStream bufin = new BufferedInputStream(fis);
        byte[] buffer = new byte[fis.available()];
        while (bufin.available() != 0) {
            bufin.read(buffer);
        }
        bufin.close();
        fis.close();
        return buffer;
    }

    public static boolean guardarFichero(String fichero, byte[] contenido) throws Exception {
        FileOutputStream fos = new FileOutputStream(fichero);
        fos.write(contenido);
        fos.close();
        return true;
    }

    public static byte[] convetirPKCS8(PrivateKey privateKey) {
        PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(privateKey.getEncoded());
        return pkcs8EncodedKeySpec.getEncoded();
    }

    public static byte[] convetirPublicKey(PublicKey publicKey) {
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(publicKey.getEncoded());
        return x509EncodedKeySpec.getEncoded();
    }

    public static String verifyBeginEndBoundaries(String certificate) {
        StringBuilder certBuilder = new StringBuilder();
        if (!certificate.startsWith(BEGIN_CERTIFICATE_BOUNDARY_TAG)) {
            certBuilder.append(BEGIN_CERTIFICATE_BOUNDARY_TAG);
            certBuilder.append(LINE_SEPARATOR);
        }
        certBuilder.append(certificate);
        if (!certificate.endsWith(END_CERTIFICATE_BOUNDARY_TAG)) {
            certBuilder.append(LINE_SEPARATOR);
            certBuilder.append(END_CERTIFICATE_BOUNDARY_TAG);
        }
        return certBuilder.toString();
    }

    public static boolean isBinary(byte[] bValue) {
        String value = new String(bValue);
        CharsetEncoder encoder = Charset.forName("ISO-8859-1").newEncoder();
        return !encoder.canEncode(value);
    }
}

